// Passive event listeners
jQuery.event.special.touchstart = {
    setup: function( _, ns, handle ) {
        this.addEventListener("touchstart", handle, { passive: !ns.includes("noPreventDefault") });
    }
};
jQuery.event.special.touchmove = {
    setup: function( _, ns, handle ) {
        this.addEventListener("touchmove", handle, { passive: !ns.includes("noPreventDefault") });
    }
};

let windowWidth = jQuery(window).width();

document.addEventListener("DOMContentLoaded", function () {
    const lazyBackgrounds = document.querySelectorAll(".lazy-bg");
    console.log(lazyBackgrounds);
    if ("IntersectionObserver" in window) {
        const lazyBgObserver = new IntersectionObserver((entries, observer) => {
            entries.forEach((entry) => {
                if (entry.isIntersecting) {
                    const el = entry.target;
                    const bg = el.getAttribute("data-bg");
                    if (bg) {
                        el.style.backgroundImage = `url(${bg})`;
                        el.classList.add("lazy-bg--loaded"); // opcjonalne: do animacji
                    }
                    lazyBgObserver.unobserve(el);
                }
            });
        });

        lazyBackgrounds.forEach((bg) => lazyBgObserver.observe(bg));
    }
});

jQuery(document).ready(function () {
    getWindowWidth();

    const $slider = jQuery('.slider__slides');

    window.requestIdleCallback(() => {
        $slider.slick({
            arrows: false,
            dots: true,
            speed: 1500,
            pauseOnHover: false,
            pauseOnFocus: false,
            accessibility: false,
        });
    });

    jQuery('.testimonials__list').slick({
        dots: true,
        appendArrows: jQuery('.testimonials__arrows'),
        prevArrow: jQuery('.testimonials__arrows .arrow--left'),
        nextArrow: jQuery('.testimonials__arrows .arrow--right'),
        slidesToShow: 3,
        responsive: [
            {
                breakpoint: 1200,
                settings: {
                    slidesToShow: 2,
                }
            },
            {
                breakpoint: 800,
                settings: {
                    slidesToShow: 1,
                }
            },
        ]
    });

    jQuery('.gallery__wrapper').slick({
        arrows: false,
        slidesToShow: 5,
        centerMode: true,
        centerPadding: '100px',
        autoplay: true,
        speed: 1500,
        pauseOnHover: false,
        pauseOnFocus: false,
        accessibility: false,
        responsive: [
            {
                breakpoint: 1200,
                settings: {
                    slidesToShow: 3,
                    centerPadding: '50px',
                }
            },
            {
                breakpoint: 700,
                settings: {
                    slidesToShow: 1,
                }
            },
            {
                breakpoint: 450,
                settings: {
                    slidesToShow: 1,
                    centerPadding: '30px',
                }
            },
        ]
    });

    jQuery('.half-slider__left').slick({
        vertical: true,
        arrows: false,
        autoplay: true,
        speed: 1500,
        pauseOnHover: false,
        pauseOnFocus: false,
    });

    jQuery('.half-slider__right').slick({
        vertical: true,
        arrows: false,
        autoplay: true,
        speed: 1500,
        pauseOnHover: false,
        pauseOnFocus: false,
        // slidesToScroll: -1,
    });

    jQuery('.node--recovery .wellness__images').slick({
        arrows: false,
        dots: true,
    });

    OrphansAndWidows('p');

    if (windowWidth < 980) {
        jQuery('.nav-icon').click(function () {
            jQuery(this).toggleClass('open');
            jQuery('.main-menu > ul').slideToggle(200);
        });

        jQuery('.menu__item.expanded').click(function () {
            jQuery('.menu--lvl-1', this).slideToggle(200);
        });
    }

    AOS.init({
    //     // delay: 300, // values from 0 to 3000, with step 50ms
        duration: 1000, // values from 0 to 3000, with step 50ms
    });
});

jQuery(window).scroll(function(){
    const fromTop = jQuery(document).scrollTop();
    if (fromTop > 100) {
        jQuery('header').addClass('scroll');
    } else {
        jQuery('header').removeClass('scroll');
    }
});

jQuery(window).resize(function() {
    getWindowWidth(200);
})

function getWindowWidth(timeout = 0) {
    clearTimeout(jQuery.data(this, 'resizeTimer'));
    jQuery.data(this, 'resizeTimer', setTimeout(function() {
        windowWidth = jQuery(window).width();
    }, timeout));
}

function OrphansAndWidows(container) {
    const content = jQuery(container);
    for (var i = 0; i < content.length; i++) {
        var tekst = content[i].innerHTML;
        //tekst = tekst.replace(/(\s)([^<][\S]{2})[\s]+/g,"$1$2&nbsp;"); //trzyznakowe
        tekst = tekst.replace(/(\s)([^<][\S]{1})[\s]+/g, "$1$2&nbsp;"); //dwuznakowe
        tekst = tekst.replace(/(\s)([\S])[\s]+/g, "$1$2&nbsp;"); //jednoznakowe
        content[i].innerHTML = tekst;
    }

}
